<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Dashboard
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Dashboard</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-3">
                <div class="small-box bg-yellow-gradient">
                    <div class="inner">
                        <h3><?=total_customers_by_country($dbc,'gh')?></h3>
                        <p>Users in Ghana</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                    <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="small-box bg-aqua-gradient">
                    <div class="inner">
                        <h3><?=total_customers_by_country($dbc,'lr')?></h3>
                        <p>Users in Liberia</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                    <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="small-box bg-gray">
                    <div class="inner">
                        <h3><?=total_customers_by_country($dbc,'us')?></h3>
                        <p>Users in United States</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                    <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="small-box bg-red-gradient">
                    <div class="inner">
                        <h3><?=total_customers_by_country($dbc,'gb')?></h3>
                        <p>Users in United Kingdom</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                    <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
        </div>


        <div class="row">
            <!-- All Ghana Transactions -->
            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow"><i class="fa fa-money"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">GH Main Transaction</span>
                        <span class="info-box-number"><?=moneyFormat(total_daily_main_transaction_by_country($dbc,'gh'))?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow"><i class="fa fa-money"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">GH Airtime Transaction</span>
                        <span class="info-box-number"><?=moneyFormat(total_daily_airtime_transaction_by_country($dbc,'gh'))?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow"><i class="fa fa-money"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">GH Bank Transaction</span>
                        <span class="info-box-number"><?=moneyFormat(total_daily_bank_transaction_by_country($dbc))?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow"><i class="fa fa-money"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">GH Commission</span>
                        <span class="info-box-number"><?=moneyFormat(total_daily_commission_by_country($dbc,'gh'))?></span>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- All Liberia Transactions -->
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-light-blue"><i class="fa fa-money"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">LR Main Transaction</span>
                        <span class="info-box-number"><?=moneyFormat(total_daily_main_transaction_by_country($dbc,'lr'))?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-light-blue"><i class="fa fa-money"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">LR Airtime Transaction</span>
                        <span class="info-box-number"><?=moneyFormat(total_daily_airtime_transaction_by_country($dbc,'lr'))?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-light-blue"><i class="fa fa-money"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">LR Commission</span>
                        <span class="info-box-number"><?=moneyFormat(total_daily_commission_by_country($dbc,'lr'))?></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <!-- All United States Transactions -->
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-gray-light"><i class="fa fa-money"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">USA Main Transaction</span>
                        <span class="info-box-number"><?=moneyFormat(total_daily_main_transaction_by_country($dbc,'us'))?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-gray-light"><i class="fa fa-money"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">USA Airtime Transaction</span>
                        <span class="info-box-number"><?=moneyFormat(total_daily_airtime_transaction_by_country($dbc,'us'))?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-gray-light"><i class="fa fa-money"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">USA Commission</span>
                        <span class="info-box-number"><?=moneyFormat(total_daily_commission_by_country($dbc,'us'))?></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <!-- All United Kingdom Transactions -->
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-red"><i class="fa fa-money"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">UK Main Transaction</span>
                        <span class="info-box-number"><?=moneyFormat(total_daily_main_transaction_by_country($dbc,'gb'))?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-red"><i class="fa fa-money"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">UK Airtime Transaction</span>
                        <span class="info-box-number"><?=moneyFormat(total_daily_airtime_transaction_by_country($dbc,'gb'))?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-red"><i class="fa fa-money"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">UK Commission</span>
                        <span class="info-box-number"><?=moneyFormat(total_daily_commission_by_country($dbc,'gb'))?></span>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>
