<?php
include "config/init.php";
include "system/bank/bank-index.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

if(isset($_POST['creditCustomer'])){
    $transaction_uid = trim(html_filter($dbc,$_POST['transaction_uid']));

    if(!empty($transaction_uid)){
        if(check_if_transaction_uid_exist_at_bank_transaction_waiting($dbc,$transaction_uid)) {
            $all_transaction = get_bank_transaction_by_transaction_uid($dbc,$transaction_uid);
            $totalAmount = $all_transaction['recipientAmount'] + $all_transaction['fee'];
            $customerData = get_customer_by_id($dbc,$all_transaction['senderID']);
            $transactionType = 'WTB';

            if($all_transaction['transactionTypes'] == 'WTB') {
                $comment = "WTB(GNMONEY {$customerData['phoneNum']} TO  {$all_transaction['senderBankAccount']})";
                $comment1 = "WALLET TO BANK ERROR";
                $res = lr_bank_transfer_funds_new($all_transaction['recipientBankAccount'], $all_transaction['senderBankAccount'], $all_transaction['recipientAmount'], 0, $comment, $all_transaction['foreignId']);

                if ($res['comment'] == "Successful") {
                    $senderAcc = get_cus_account_info_by_customerID($dbc, $all_transaction['senderID']);
                    $recipientAcc = get_cus_account_info_by_customerID($dbc, $all_transaction['recipientID']);
                    if (update_bank_transaction_balance_and_complete($dbc, $transaction_uid, $recipientAcc['balance'], $senderAcc['balance'])) {
                        $q = mysqli_query($dbc, "INSERT INTO transitResolver_tbl(id, customerID, amount, transaction_uid, transactionType, comment, user_id) VALUES 
                          (UUID(),'$all_transaction[senderID]','$all_transaction[sendersAmount]','$transaction_uid','$transactionType','$comment1','$_SESSION[uid]')
                        ");
                        if ($q) {
                            $pricing = get_pricing_by_id($dbc, $all_transaction['pricing_id']);
                            if ($customerData['accountType'] == 4) {
                                $payGlobalFee = $all_transaction['fee'] * $pricing['sysCommission'];
                                $agentFee = $all_transaction['fee'] * $pricing['senderCommission'];
                                if (add_agent_commission_for_addMoney($dbc, $all_transaction, $agentFee, $customerData['countryCode'], $customerData['id'])) {
                                    if (add_payGlobal_commission($dbc, $customerData, $payGlobalFee)) {
                                        $result = "<p class='alert alert-success'>GN Mobile Money to your account number {$all_transaction['senderBankAccount']} with the amount of {$all_transaction['sendersAmount']} has been completed  </p>";
                                        $message = "Your Account {$all_transaction['senderBankAccount']} has been Credited with an amount of {$all_transaction['sendersAmount']} from GN Money/PayGlobal. transaction ID: {$transaction_uid} ";
                                        sendSMS($customerData['phoneNum'], $message);
                                    }
                                }
                            } else {
                                $payGlobalFee = $all_transaction['fee'] * $pricing['sysCommission'];
                                if (add_payGlobal_commission($dbc, $customerData, $payGlobalFee)) {
                                    $result = "<p class='alert alert-success'>GN Mobile Money to your account number {$all_transaction['senderBankAccount']}  with the amount of {$all_transaction['sendersAmount']} has been completed  </p>";
                                    $message = "Your Account {$all_transaction['senderBankAccount']} has been Credited with an amount of {$all_transaction['sendersAmount']} from GN Money/PayGlobal. transaction ID: {$transaction_uid} ";
                                    sendSMS($customerData['phoneNum'], $message);
                                }
                            }


                        } else {
                            $result = "<p class='alert alert-danger'>System Error..</p>";

                        }
                    }
                } else {
                    $result = "<p class='alert alert-danger'>System Error occur..</p>";
                }
            }else{
                $result = "<p class='alert alert-danger'>Transaction type not the same</p>";
            }
        } else{
            $result = "<p class='alert alert-danger'>Transaction ID does not exist or not a waiting status</p>";
        }
    } else{
        $result = "<p class='alert alert-danger'>All fields required</p>";
    }

}

?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Wallet To Bank Resolver
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php
            if(isset($result)){echo $result;}
        ?>
        <div class="row">
            <div class="col-md-4">
                <div class="box box-default">
                    <div class="box-header with-border">Credit Customer Account From Transit if bank failed.</div>
                    <div class="box-body">
                        <form method="post" role="form" onsubmit="return confirm('Are you sure you want to do this transaction');">
                            <div class="form-group">
                                <label for="transaction_uid">Transaction ID</label>
                                <input type="text" name="transaction_uid" id="transaction_uid" required class="form-control">
                            </div>
                            <button class="btn btn-primary" name="creditCustomer" type="submit" id="creditCustomer">Credit Customer</button>

                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="box box-success">
                    <div class="box-header with-border">List of Bank Resolve Issues Account</div>
                    <div class="box-body">
                        <table class="table table-striped" id="list-transit-resolver">
                            <thead>
                            <tr>
                                <th>Date</th>
                                <th>customer</th>
                                <th>Amount</th>
                                <th>Transaction ID</th>
                                <th>Transaction TYPE</th>
                                <th>Comment</th>
                                <th>User</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>



            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


