<?php
include "config/init.php";
include "system/bank/bank-index.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

function get_waiting_bank_transactions($dbc,$serviceType){
    $q = mysqli_query($dbc,"SELECT * FROM bank_transactions_tbl WHERE transactionStatus = 'WAITING' AND serviceType = '$serviceType'");
    $data = array();
    while ($row = mysqli_fetch_assoc($q)){
        $data[] = $row;
    }
    return $data;
}


if(isset($_POST['resolve_now'])){
    $serviceType = html_filter($dbc,$_POST['serviceType']);
    $transitAccount = html_filter($dbc,$_POST['transitAccount']);

    if(!empty($serviceType)){
        $transactions = get_waiting_bank_transactions($dbc,$serviceType);

        if($serviceType == 'WTB'){

            foreach ($transactions AS $transaction){
                $transaction_uid = $transaction['transaction_uid'];
                $findCustomer = $transaction['senderID'];
                $fee = $transaction['fee'];
                $senderAmount = $transaction['senderAmount'];
                $getTransaction = get_bank_transaction_by_transaction_uid($dbc,$transaction_uid);
                if(check_if_transaction_uid_exist_at_bank_transaction($dbc,$transaction_uid)) {
                    $customerData = get_customer_by_id($dbc,$findCustomer);
                    $amount = $senderAmount + $fee;
                    if (redrawFunds_from_payGlobal_transitAccount_after_wtb_error($dbc, $senderAmount, $transitAccount)) {
                        if (add_funds($dbc, $findCustomer, $amount)) {
                            if (update_bank_transaction_after_success_refund($dbc, $transaction_uid)) {
                                $comment = "Wallet to bank Error";
                                $q = mysqli_query($dbc,"INSERT INTO transitResolver_tbl(id, customerID, amount, transaction_uid, transactionType, comment, user_id) VALUES 
                                  (UUID(),'$findCustomer','$amount','$transaction_uid','$serviceType','$comment','$_SESSION[uid]')
                                  ");
                                if($q){
                                    $result = "<p class='alert alert-success'>Process completed!!!</p>";
                                    $message = "Your wallet has been refund with an amount of {$amount} from GN Money/PayGlobal. transaction ID: {$transaction_uid} ";
                                    sendSMS($customerData['phoneNum'],$message);
                                } else{
                                    $result = "<p class='alert alert-danger'>System Error..</p>";

                                }

                            } else{
                                $result = "<p class='alert alert-danger'>System Error occur..</p>";

                            }
                        }else{
                            $result = "<p class='alert alert-danger'>Can't Add funds to customer</p>";
                        }
                    }else{
                        $result = "<p class='alert alert-danger'>No funds in Transit Account</p>";

                    }
                } else{
                    $result = "<p class='alert alert-danger'>Transaction ID does not exist</p>";
                }
            }

        }elseif($serviceType == 'BTW'){
            $result = '<p class="alert alert-danger">Invalid transaction Type</p>';
        }else{
            $result = '<p class="alert alert-danger">Invalid transaction Type</p>';
        }

    } else{
        $result = "<p class='alert alert-danger'>All fields required</p>";
    }

}

?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Resolver
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php
            if(isset($result)){echo $result;}
        ?>
        <div class="row">
            <div class="col-md-4">
                <div class="box box-default">
                    <div class="box-header with-border">Credit Customer Account From Transit if bank failed.</div>
                    <div class="box-body">
                        <form method="post" role="form" onsubmit="return confirm('Are you sure you want to do this transaction');">
                            <div class="form-group">
                                <label for="transitAccount">Transit Account</label>
                                <select class="form-control" name="transitAccount" required id="transitAccount">
                                    <option value="">Select Transit Account</option>
                                    <?php
                                    $transitLists = get_all_PayGlobalAccounts($dbc);
                                    foreach ($transitLists as $transitList){
                                        echo "<option value='{$transitList['countryCode']}'>{$transitList['transitAccount']} {$transitList['countryCode']}</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="serviceType">Service Type</label>
                                <select class="form-control" name="serviceType" required id="serviceType">
                                    <option value="">Select Transit Account</option>
                                    <option value="WTB">Wallet to Bank</option>
                                    <option value="BTW">Bank to Wallet</option>
                                </select>
                            </div>

                            <button class="btn btn-primary" name="resolve_now" type="submit" id="resolve_now">Resolve Now</button>

                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-8">

            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


