<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

if($_SESSION['role'] != 'SYSTEMADMIN' || $_SESSION['role'] != 'ADMINISTRATOR'){
    header("location:index.php");
    die();
}

// add new service pricing
if(isset($_POST['add-accType'])){
    $accountType = html_filter($dbc,$_POST['accountType']);
    if(!empty($accountType)){
        if(add_new_accountType($dbc,$accountType)){
            $result = "<p class='alert alert-success'>New Account Type Added</p>";
        }else{
            $result = "<p class='alert alert-danger'>Error!, Please try Later</p>";
        }
    } else{
        $result = "<p class='alert alert-danger'>Fields is Required</p>";
    }
}

// Edit service Pricing
if(isset($_GET['edit_cus_type'])){
    $service_data = get_service_pricing_by_id($dbc,$_GET['edit_service']);
    if($service_data['id'] == ''){
        header("Location:service-pricing.php");
        die();
    }
}


?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Customer Account Type
        </h1>
        <ol class="breadcrumb">
            <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Customer Account Type</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php if(isset($result)){echo $result;} ?>
        <div class="row">
            <div class="col-md-4">
                <div class="box box-primary">
                    <?php
                    if(isset($_GET['edit_service'])){
                        // Update account Type Section
                        ?>
                        <?php
                    } else{
                        ?>
                        <div class="box-header with-border">Add New Account Type</div>
                        <div class="box-body">
                            <form role="form" method="post">
                                <div class="form-group">
                                    <label for="accountType">AccountType Name</label>
                                    <input type="text" name="accountType" class="form-control" id="accountType" required>
                                </div>
                                <button type="submit" class="btn-block btn btn-primary" name="add-accType">Submit</button>
                            </form>
                        </div>
                        <?php
                    }
                    ?>
                </div>
            </div>
            <div class="col-md-8">
                <div class="box box-success">
                    <div class="box-header with-border">List of Account Types</div>
                    <div class="box-body">
                        <table class="table table-striped" id="accountType">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>Account Type</th>
                                <th>Added By</th>
                                <th>Date</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                                $accountTypeData = get_all_from_accountType($dbc);
                                foreach ($accountTypeData as $accTypeData){
                                    $user = get_user_by_id($dbc,$accTypeData['added_by']);
                            ?>
                                    <tr>
                                        <td><?=$accTypeData['id']?></td>
                                        <td><?=$accTypeData['accountType']?></td>
                                        <td><?=$user['fullName']?></td>
                                        <td><?=$accTypeData['dateTime']?></td>
                                    </tr>
                            <?php
                                }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


