<?php
include "config/init.php";
include "system/hubtel/hubtel_func.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

if(isset($_POST['creditCustomer'])){
    $transaction_uid = trim(html_filter($dbc,$_POST['transaction_uid']));
    $hubtel_tnx = trim(html_filter($dbc,$_POST['hubtel_tnx']));

    $transactionType = "PUSH";

    if(!empty($transaction_uid) AND !empty($hubtel_tnx)){
        if(check_if_transaction_uid_exist_at_hubtel_transaction($dbc,$transaction_uid,$transactionType,$hubtel_tnx)) {
            $all_transaction = get_hub_transactionData_by_tnx_and_transaction_uid($dbc,$transaction_uid,$hubtel_tnx);
            $fee = $all_transaction['amount']  * 0.01; // Fee for cash out
            $mm_amount = $all_transaction['amount'] * 1;
            $totalAmount = $fee + $mm_amount;
            $customerData = get_customer_by_id($dbc,$all_transaction['customerID']);
            $global_hubtel_Acc = get_customer_by_phoneNum($dbc, "+233770000000");
            if (redraw_funds($dbc,$global_hubtel_Acc['id'],$totalAmount)) {
                if (add_funds($dbc, $customerData['id'], $totalAmount)) {
                    $cusAcc = get_cus_account_info_by_customerID($dbc,$all_transaction['customerID']);
                    if (update_hubtel_transaction_after_success_refund($dbc, $transaction_uid,$cusAcc['balance'],'CANCELLED')) {
                        $q = mysqli_query($dbc,"INSERT INTO hubtel_resolver_tbl (id, transaction_uid, transactionType, hubtel_txn, customerID, phoneNumber, amount,user)
                        VALUES (UUID(),'$transaction_uid','PUSH','$all_transaction[hubtel_txn]','$customerData[id]','$all_transaction[phoneNumber]','$totalAmount','$_SESSION[uid]')
                        ");
                        if($q){
                            $result = "<p class='alert alert-success'>You have refund {$totalAmount} to a customer by the name {$customerData['fullName']} {$customerData['companyName']}</p>";
                            $message = "Your wallet has been refund with an amount of {$totalAmount} from GN Money/PayGlobal. transaction ID: {$transaction_uid} ";
                            sendSMS($customerData['phoneNum'],$message);
                        } else{
                            $result = "<p class='alert alert-danger'>System Error..</p>";

                        }

                    } else{
                        $result = "<p class='alert alert-danger'>System Error occur..</p>";

                    }
                }else{
                    $result = "<p class='alert alert-danger'>Can't Add funds to customer</p>";
                }
            }else{
                $result = "<p class='alert alert-danger'>No funds in Transit Account</p>";

            }
        } else{
            $result = "<p class='alert alert-danger'>Transaction ID does not exist</p>";
        }
    } else{
        $result = "<p class='alert alert-danger'>All fields required</p>";
    }

}

?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Hubtel Push Resolver
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php
            if(isset($result)){echo $result;}
        ?>
        <div class="row">
            <div class="col-md-4">
                <div class="box box-default">
                    <div class="box-header with-border">Credit Customer Wallet of failed Transactions.</div>
                    <div class="box-body">
                        <form method="post" role="form" onsubmit="return confirm('Are you sure you want to do this transaction');">

                            <div class="form-group">
                                <label for="transaction_uid">Transaction ID</label>
                                <input type="text" name="transaction_uid" id="transaction_uid" required class="form-control">
                            </div>
                            <div class="form-group">
                                <label for="hubtel_tnx">Hubtel TXN</label>
                                <input type="text" name="hubtel_tnx" id="hubtel_tnx" required class="form-control">
                            </div>
                            <button class="btn btn-primary" name="creditCustomer" type="submit" id="creditCustomer">Credit Customer</button>

                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="box box-success">
                    <div class="box-header with-border">List of Hubtel Resolver</div>
                    <div class="box-body">
                        <table class="table table-striped" id="">
                            <thead>
                            <tr>
                                <th>Date</th>
                                <th>customer</th>
                                <th>Amount</th>
                                <th>Transaction Type</th>
                                <th>Phone Number</th>
                                <th>Transaction ID</th>
                                <th>Hubtel TXN</th>
                                <th>User</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            $ListResolves = get_all_hubtel_resolved($dbc);
                            foreach($ListResolves as $value){
                                $customerData2 = get_customer_by_id($dbc,$value['customerID']);
                                $userData = get_user_by_id($dbc,$value['user']);
                                ?>
                                <tr>
                                    <td><?=$value['dateTime'] ?></td>
                                    <td><?=$customerData2['fullName']." ".$customerData2['companyName'] ?></td>
                                    <td><?=$value['amount'] ?></td>
                                    <td><?=$value['transactionType'] ?></td>
                                    <td><?=$value['phoneNumber'] ?></td>
                                    <td><?=$value['transaction_uid'] ?></td>
                                    <td><?=$value['hubtel_txn'] ?></td>
                                    <td><?=$userData['fullName'] ?></td>
                                </tr>
                                <?php
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>



            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


