<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";


// Update Exchange Rate
if(isset($_POST['rate'])){
    $rate = html_filter($dbc,$_POST['rate']);
    if(!empty($rate)){
        if(update_exchangeRate($dbc,$_GET['c_edit'],$rate)){
            $result = "<p class='alert alert-success'>Rate Updated</p>";
        }else{
            $result = "<p class='alert alert-danger'>Error!, Please try Later</p>";
        }
    } else{
        $result = "<p class='alert alert-danger'>Fields is Required</p>";
    }
}

// Edit service Pricing
if(isset($_GET['c_edit'])){
    $exchange_data = get_currency_mgt_by_id($dbc,$_GET['c_edit']);
    if($exchange_data['id'] == ''){
        header("Location:currency-mgt.php");
        die();
    }
}


?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Forex Accounts
        </h1>
        <ol class="breadcrumb">
            <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Forex Account</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-success">
                    <div class="box-header with-border">Forex Accounts</div>
                    <div class="box-body">
                        <table class="table table-striped" id="currencyExchange">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>Country</th>
                                <th>Local Acc Credit</th>
                                <th>Local Acc Debit</th>
                                <th>Dominant Acc Credit</th>
                                <th>Dominant Acc Debit</th>
                                <th>Net Position</th>
                                <th>Date</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            $forexAccounts = get_forex_account($dbc);
                            foreach ($forexAccounts as $forexAccount){
                                $currency = get_currency_by_countryCode($dbc,$forexAccount['countryCode']);
                                $netPosition = $forexAccount['dominantUSDaccountCredit'] - $forexAccount['dominantUSDaccountDebit'];
                                ?>
                                <tr>
                                    <td><?=$forexAccount['id']?></td>
                                    <td><?=$forexAccount['countryCode']?></td>
                                    <td><?=$currency['currency'].' '.$forexAccount['localAccountCredit']?></td>
                                    <td><?=$currency['currency'].' '.$forexAccount['localAccountDebit']?></td>
                                    <td>USD <?=$forexAccount['dominantUSDaccountCredit']?></td>
                                    <td>USD <?=$forexAccount['dominantUSDaccountDebit']?></td>
                                    <td>USD <?=$netPosition?></td>
                                    <td><?=$forexAccount['DateTime']?></td>
                                </tr>
                                <?php
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


