<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";
if($_SESSION['role'] != 'SYSTEMADMIN'){
    header("location:index.php");
    die();
}

if(isset($_POST['creditAccount'])){
    $devAccount = html_filter($dbc,$_POST['devAccount']);
    $gloAccount = html_filter($dbc,$_POST['gloAccount']);
    $comment = html_filter($dbc,$_POST['comment']);
    $amount = html_filter($dbc,$_POST['amount']);
    if(!empty($devAccount) AND !empty($gloAccount) AND !empty($amount) AND !empty($comment)){
        $devAccountData = get_devAccount_by_id($dbc,$devAccount);
        if($devAccountData['balance'] > $amount){
            if(credit_gloAccount_from_devAccount($dbc,$gloAccount,$devAccount,$amount,$comment)){
                $result = "<p class='alert alert-success'>Global Account has been fund with an amount of {$amount}</p>";
            } else{
                $result = "<p class='alert alert-danger'>An Error Occur, Try again</p>";
            }
        }else{
            $result = "<p class='alert alert-danger'>You don't have enough Balance</p>";
        }

    } else{
        $result = "<p class='alert alert-danger'>All fields required</p>";
    }
}

?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Developers Account
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Developers Account</a></li>
            <li class="active">Dashboard</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php
            if(isset($result)){echo $result;}
        ?>
        <div class="row">
            <div class="col-md-3">
                <div class="box box-default">
                    <div class="box-header with-border">Credit Global Account</div>
                    <div class="box-body">
                        <form method="post" role="form">
                            <div class="form-group">
                                <label for="devAccount">Developers Account</label>
                                <select class="form-control" name="devAccount" required id="devAccount">
                                    <option value="">Select Developers Account</option>
                                    <?php
                                    $devLists = get_all_developers_account($dbc);
                                    foreach ($devLists as $devList){
                                        echo "<option value='{$devList['id']}'>{$devList['accountName']}</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="gloAccount">Global Account</label>
                                <select class="form-control" name="gloAccount" required id="gloAccount">
                                    <option value="">Select Global Account</option>
                                    <?php
                                    $gloLists = get_all_global_account($dbc);
                                    foreach ($gloLists as $gloList){
                                        echo "<option value='{$gloList['id']}'>{$gloList['accountName']}</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="amount">Amount</label>
                                <input type="number" minlength="1" name="amount" id="amount" required step="any" class="form-control">
                            </div>
                            <div class="form-group">
                                <label for="comment">Narration</label>
                                <textarea class="form-control" id="comment" name="comment"></textarea>
                            </div>
                            <button class="btn btn-primary" name="creditAccount" type="submit" id="creditAccount">Credit Account</button>

                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-9">
                <!-- List of developers Account -->
                <div class="box box-success">
                    <div class="box-header with-border">List of Transactions</div>
                    <div class="box-body">
                        <table class="table table-striped" id="devAccount_transactions">
                            <thead>
                            <tr>
                                <th>From</th>
                                <th>To</th>
                                <th>Amount</th>
                                <th>Added By</th>
                                <th>Narration</th>
                                <th>Date</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>


                <div class="box box-success">
                    <div class="box-header with-border">List of Developers Account</div>
                    <div class="box-body">
                        <table class="table table-striped" id="">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Country</th>
                                    <th>Balance</th>
                                    <th>Credit</th>
                                    <th>Debit</th>
                                    <th>Created By</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                            $ListDevAccount = get_all_developers_account($dbc);
                            foreach($ListDevAccount as $value){
                                $countryData = get_country_code_with_currency($dbc,$value['country']);
                                $userData = get_user_by_id($dbc,$value['created_by']);
                                $num = 1;
                                ?>
                                <tr>
                                    <td><?=$num ?></td>
                                    <td><?=$value['accountName'] ?></td>
                                    <td><?=$countryData['currency']." ".$value['balance'] ?></td>
                                    <td><?=$countryData['currency']." ".$value['credit'] ?></td>
                                    <td><?=$countryData['currency']." ".$value['debit'] ?></td>
                                    <td><?=$userData['fullName'] ?></td>
                                    <td><?=$value['dateTime'] ?></td>
                                </tr>
                                <?php
                                $num++;
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


