<?php
include "config/init.php";
include "system/zenith/func_card.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

if(isset($_POST['verify'])){
    $cardID = trim(html_filter($dbc,$_POST['findCard']));
    $amount = trim(html_filter($dbc,$_POST['amount']));

    if(!empty($cardID) AND !empty($amount)){
        $cardData = z_get_cc_card_by_cardID($dbc,$cardID);
        $customerData = get_customer_by_id($dbc,$cardData['customerID']);
        if (z_check_customer_already_signUp($dbc, $customerData['id'])) {
            if (z_check_if_cardID_exist($dbc, $cardID, $customerData['id'])) {
                $signUpData = z_get_cc_signUp_by_customerID($dbc, $customerData['id']);
                $data = z_confirm_new_card($dbc, $customerData, $cardID, $amount);
                if ($data['confirm-status'] == 'true'){

                    $result = 'Thank you, Your card has been confirmed';
                    $message = 'Please be informed that your card has been verified for use on PayGlobal. You can now use your card to add money to your wallet';

                    sendSMS($customerData['phoneNum'],$message);
                    activity_log($dbc,"Card Confirm on card ID {$cardID}, amount of {$amount} on a customer phone number ({$customerData['phoneNum']})",'VERIFY-CARD');

                } else {
                    $result = 'Invalid Confirmation Amount';

                }
            } else {

                $result = "Debit Card Do not exist or Already added";
            }
        } else {
            $result = 'Customer Debit Card Option Not activated';
        }
    } else{
        $result = "<p class='alert alert-danger'>All fields required</p>";
    }

}

?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Verify Visa Card
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php
            if(isset($result)){echo $result;}
        ?>
        <div class="row">
            <div class="col-md-3">
                <div class="box box-default">
                    <div class="box-header with-border">Verify Card</div>
                    <div class="box-body">
                        <form method="post" role="form" onsubmit="return confirm('Are you sure you want confirm this card');">
                            <div class="form-group">
                                <label for="findCard">Card Number</label>
                                <select class="form-control" name="findCard" id="findCard">
                                    <option value="">Search card</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="amount">Amount</label>
                                <input type="number" step="any" name="amount" id="amount" required class="form-control">
                            </div>
                            <button class="btn btn-primary" name="verify" type="submit" id="verify">Verify Card</button>

                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-9">
                <div class="box box-default">
                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs">
                            <li class="active"><a href="#cc_waiting" data-toggle="tab">Waiting Cards</a></li>
                            <li><a href="#cc_active" data-toggle="tab">Active Cards</a></li>
                        </ul>
                        <div class="tab-content">

                            <div class="tab-pane active" id="cc_waiting">
                                <table class="table table-striped" id="cc_waiting_list">
                                    <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Customer</th>
                                        <th>Card Name</th>
                                        <th>Customer Country</th>
                                        <th>Card ID</th>
                                        <th>Zenith ID</th>
                                        <th>Card Number</th>
                                        <th>Type</th>
                                        <th>status</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                            <!-- /.tab-pane -->
                            <div class="tab-pane" id="cc_active">
                                <table class="table table-striped" id="cc_activated">
                                    <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Customer</th>
                                        <th>Card Name</th>
                                        <th>Customer Country</th>
                                        <th>Card ID</th>
                                        <th>Zenith ID</th>
                                        <th>Card Number</th>
                                        <th>Type</th>
                                        <th>status</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>

                        </div>
                        <!-- /.tab-content -->
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


