    <?php
    include "config/init.php";
    include "system/bank/bank-index.php";
    include "template/header.php";
    //Main Header
    include "template/main-header.php";
    //Left side column. contains the logo and sidebar -->
    include "template/main-sidebar.php";

    if(isset($_POST['creditCustomer'])){
        $transitAccount = html_filter($dbc,$_POST['transitAccount']);
        $cusAcc = html_filter($dbc,$_POST['cusAcc']);
        $newAmount = html_filter($dbc,$_POST['newAmount']);
        $phoneNum = html_filter($dbc,$_POST['phoneNum']);

        if(!empty($transitAccount) AND !empty($cusAcc)){
            $transAcc = get_global_Accounts($dbc,$transitAccount);
                $cusData = get_customer_by_phoneNum($dbc,$phoneNum);
                $amount = $newAmount;
                $findCustomer = $cusData['id'];
                if(check_existing_balance($dbc,$findCustomer,$amount)) {
                    $res = bank_transfer_funds2($transAcc['transitAccount'], $cusAcc, $amount, 0, "GNMM BTW REVERSALS", $transactionData['foreignId']);
                    if ($res['comment'] == 'Successful') {

                        if (redraw_funds($dbc, $findCustomer, $amount)) {
                            if (add_funds($dbc, 'aba75624-4c44-11e8-bcaf-ac1f6b006500', $amount)) {
                                    $result = "<p class='alert alert-success'>Reversal Done Successful</p>";

                            } else {
                                $result = "<p class='alert alert-danger'>Error Adding</p>";
                            }
                        } else {
                            $result = "<p class='alert alert-danger'>Error Redrawing</p>";

                        }
                    } else {
                        $result = "<p class='alert alert-danger'>Error in Bank Transactions</p>";
                    }
                } else{
                    $result = "<p class='alert alert-danger'>Low Balance</p>";
                }
        } else{
            $result = "<p class='alert alert-danger'>All fields required</p>";
        }

    }

    ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                Bank Reversal
            </h1>
        </section>

        <!-- Main content -->
        <section class="content">
            <?php
                if(isset($result)){echo $result;}
            ?>
            <div class="row">
                <div class="col-md-4">
                    <div class="box box-default">
                        <div class="box-header with-border">Credit Customer Account From Transit if bank failed.</div>
                        <div class="box-body">
                            <form method="post" role="form" onsubmit="return confirm('Are you sure you want to do this transaction');">
                                <div class="form-group">
                                    <label for="transitAccount">Transit Account</label>
                                    <select class="form-control" name="transitAccount" required id="transitAccount">
                                        <option value="">Select Transit Account</option>
                                        <?php
                                        $transitLists = get_all_PayGlobalAccounts($dbc);
                                        foreach ($transitLists as $transitList){
                                            echo "<option value='{$transitList['countryCode']}'>{$transitList['transitAccount']} {$transitList['countryCode']}</option>";
                                        }
                                        ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="cusAcc">Customer Account</label>
                                    <input type="text" name="cusAcc" id="cusAcc" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label for="newAmount">Amount</label>
                                    <input type="text" name="newAmount" id="newAmount" required class="form-control">
                                </div>
                                <div class="form-group">
                                    <label for="phoneNum">phoneNum</label>
                                    <input type="text" name="phoneNum" id="phoneNum" required class="form-control">
                                </div>
                                <button class="btn btn-primary" name="creditCustomer" type="submit" id="creditCustomer">Credit Customer</button>

                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="box box-success">
                        <div class="box-header with-border">List of Bank Resolve Issues Account</div>
                        <div class="box-body">
                            <table class="table table-striped" id="list-transit-resolver">
                                <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>customer</th>
                                    <th>Amount</th>
                                    <th>Transaction ID</th>
                                    <th>Transaction TYPE</th>
                                    <th>Comment</th>
                                    <th>User</th>
                                </tr>
                                </thead>

                            </table>
                        </div>
                    </div>



                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <?php include "template/footer.php"?>


